@echo off
@rem Copyright 2019-2025 NXP
@rem SPDX-License-Identifier: BSD-3-Clause
@rem The script for writing the image into MIMXRT1060  

@rem Environment variables - absolute paths simplifying re-use of the script on another machine
@rem - Absolute path to SPT workspace (it is recommended to copy/move all user files in this workspace)
SETLOCAL ENABLEDELAYEDEXPANSION
if "%SPT_WORKSPACE%"=="" (
  SET "SPT_WORKSPACE=%~dp0"
  SET "SPT_WORKSPACE=!SPT_WORKSPACE:~0,-1!"
)
ENDLOCAL & SET "SPT_WORKSPACE=%SPT_WORKSPACE%"
if not exist "%SPT_WORKSPACE%\" (
  @echo FAILURE: Directory not found "%SPT_WORKSPACE%"
  exit /B 2
)
@rem - Absolute path to SPT installation directory
if "%SPT_INSTALL_BIN%"=="" (
  SET "SPT_INSTALL_BIN=\Applications\SEC_Provi_25.12\MCUXpresso Secure Provisioning Tool 25.12.app\Contents\Frameworks"
)
if not exist "%SPT_INSTALL_BIN%\" (
  @echo FAILURE: Directory not found "%SPT_INSTALL_BIN%"
  exit /B 2
)
@rem - SPSDK debug log, absolute path
if "%SPSDK_DEBUG_LOG_FILE%"=="" (
  SET "SPSDK_DEBUG_LOG_FILE=%SPT_WORKSPACE%\logs\spsdk-debug.log"
)

@rem Use parameter: "sdphost_connect <connection_param>" to use custom connection parameters for sdphost
@rem Use parameter: "blhost_connect <connection_param>" to use custom connection parameters for blhost
@rem     <connection_param> should be in format "-p COMx[,baud]" or "-u VID,PID"
@rem Use parameter: "manufacturing_task_no index" to set number/index of the manufacturing task (to avoid same filename created from two tasks)
@rem Use parameter: "set_sdphost_baud_rate <baud_rate>" to change baud rate from default (115200) to specfied speed
@rem Use parameter: "erase_all" to perform an erase of the entire flash memory instead erasing only regions that will be written

@rem Default connection parameters
set sdphost_connect=-u 0x1FC9,0x0135
set "set_sdphost_baud_rate=115200"
set blhost_connect=-u 0x15A2,0x0073
set "manufacturing_task_no="

@echo ### Parse input arguments ###
:test_param_loop
if [%1]==[] (
  goto test_param_end
)
set param=%1
set known_param=0
if "%param%"=="blhost_connect" (
    set blhost_connect=%~2
    SHIFT
    set known_param=1
)
if "%param%"=="sdphost_connect" (
    set sdphost_connect=%~2
    SHIFT
    set known_param=1
)
if "%param%"=="manufacturing_task_no" (
    set manufacturing_task_no=%~2
    SHIFT
    set known_param=1
)
if "%param%"=="erase_all" (
    set erase_all=1
    set known_param=1
)
if "%param%"=="set_sdphost_baud_rate" (
    set set_sdphost_baud_rate=%~2
    SHIFT
    set known_param=1
)
if %known_param%==0 (
    echo ERROR: unsupported argument "%param%"
    exit /B 2
)
@rem Check for further batch arguments
SHIFT
goto test_param_loop
:test_param_end

@rem Used command line utilities
SET "blhost=%SPT_INSTALL_BIN%\tools_scripts\blhost_spsdk_win_wrapper.bat"
SET "sdphost=%SPT_INSTALL_BIN%\tools_scripts\sdphost_spsdk_win_wrapper.bat"

@rem Call hook that can modify environment variables
call :hook_execute
if errorlevel 1 exit /B 2
@rem hook executed before any other command is executed
call :hook_execute started
if errorlevel 1 exit /B 2

@echo ### Check presence of FlashLoader ###
call "%blhost%" %blhost_connect% -j -- get-property 1 0 > nul 2> nul
if errorlevel 2 (
    @echo FlashLoader is not running yet, download and run it

    if "%set_sdphost_baud_rate%" NEQ "115200" (
        if "%set_sdphost_baud_rate%" EQU "" (
            @echo set_sdphost_baud_rate is not defined
            exit /B 2
        )
        @echo ### Change speed of communication if uart is used at non-default speed ###
        setlocal EnableDelayedExpansion
        set sdphost_connect_default_speed=%%sdphost_connect:%set_sdphost_baud_rate%=115200%%
        call "%sdphost%" !sdphost_connect_default_speed! -j -- error-status
        if errorlevel 2 goto test_connection
        call "%sdphost%" !sdphost_connect_default_speed! set-baudrate %set_sdphost_baud_rate%
        :test_connection
        endlocal
        call "%sdphost%" %sdphost_connect% -j -- error-status
        if errorlevel 2 (
            call "%sdphost%" %sdphost_connect% -j -- error-status
            if errorlevel 2 exit /B 2
        )
    )

    @echo ### Check communication with target bootloader ###
    call "%sdphost%" %sdphost_connect% -j -- error-status
    if errorlevel 2 exit /B 2

    @echo ### Write FlashLoader ###
    call "%sdphost%" %sdphost_connect% -j -- write-file 0x20001C00 "%SPT_WORKSPACE%\bootable_images\unsigned_MIMXRT1060_flashloader.bin"
    if errorlevel 2 exit /B 2

    @echo ### Start FlashLoader ###
    call "%sdphost%" %sdphost_connect% -j -- jump-address 0x20001C00
    if errorlevel 2 exit /B 2

    @echo ### Waiting FlashLoader to be initialized for 3 seconds ###
    @echo ### Timeout wait value can be adjusted from Preferences ###
    setlocal EnableDelayedExpansion
    SET /A "timeout=3 + 1"
    ping -n !timeout! 127.0.0.1 >NUL
    endlocal

    @echo ### Check presence of FlashLoader ###
    call "%blhost%" %blhost_connect% -j -- get-property 1 0
    if errorlevel 2 exit /B 2
)
@rem hook executed after write of the flashloader is done
call :hook_execute flashloader_written
if errorlevel 1 exit /B 2

set "any_burn_fuses_phase1=0"

@echo ### Configure FlexSPI NOR memory using options on address 0x2000 ###
call "%blhost%" %blhost_connect% -j -- fill-memory 0x2000 4 0xC0000008 word
if errorlevel 2 exit /B 2
call "%blhost%" %blhost_connect% -j -- configure-memory 9 0x2000
if errorlevel 2 exit /B 2
@rem hook executed after external memory configuration is done
call :hook_execute configure_ext_memory_done
if errorlevel 1 exit /B 2

@echo ### Erase memory before writing image ###
if [%erase_all%] == [1] (
    call "%blhost%" %blhost_connect% -j -- flash-erase-all 9
    if errorlevel 2 exit /B 2
) else (
    call "%blhost%" %blhost_connect% -j -- flash-erase-region 0x60000000 1693576 0
    if errorlevel 2 exit /B 2
)
@rem hook executed after erase of the memory is done
call :hook_execute erase_done
if errorlevel 1 exit /B 2

@echo ### Create Flash Configuration Block [FCB] using option on address 0x2000 ###
call "%blhost%" %blhost_connect% -j -- fill-memory 0x2000 4 0xF000000F word
if errorlevel 2 exit /B 2
call "%blhost%" %blhost_connect% -j -- configure-memory 9 0x2000
if errorlevel 2 exit /B 2
@rem hook executed after creation of FCB in the memory is done
call :hook_execute create_fcb_done
if errorlevel 1 exit /B 2

@echo ### Write image ###
call "%blhost%" %blhost_connect% -j -- write-memory 0x60001000 "%SPT_WORKSPACE%\bootable_images\disting_NT.bin" 0
if errorlevel 2 exit /B 2
@rem hook executed after write of the image is done
call :hook_execute image_written
if errorlevel 1 exit /B 2
@rem hook executed after all steps of the script were executed
call :hook_execute finished
if errorlevel 1 exit /B 2
@rem Script finished successfully
exit /B 0


@rem SUBROUTINE hook script execution
:hook_execute
@rem call dummy command to ensure error level is cleared
@time /t > nul
if "%~1"=="" (
    if exist "%SPT_WORKSPACE%\hooks\write_context_win.bat" (
        call "%SPT_WORKSPACE%\hooks\write_context_win.bat"
    )
) else (
    if exist "%SPT_WORKSPACE%\hooks\write_win.bat" (
        call "%SPT_WORKSPACE%\hooks\write_win.bat" %~1
    )
)
goto :eof